; portable executable file loader
; written by alexander yaworsky
; september '99
; todo LocalAlloc->VirtualAlloc

.386p

FILE_RES_TYPE    EQU   6               ; don't care - may be any value
FILE_RES_ID      EQU   1

extrn ExitProcess:NEAR,GetCurrentProcess:NEAR,FindResourceA:NEAR
extrn LoadResource:NEAR,SizeofResource:NEAR,LocalAlloc:NEAR
extrn VirtualProtectEx:NEAR,LoadLibraryA:NEAR,GetProcAddress:NEAR
extrn GetModuleHandleA:NEAR,lstrcmpi:NEAR
extrn __imp__accept@12:NEAR,__imp__bind@12:NEAR,__imp__closesocket@4:NEAR
extrn __imp__connect@12:NEAR,__imp__getsockname@12:NEAR,__imp__htonl@4:NEAR
extrn __imp__htons@4:NEAR,__imp__listen@8:NEAR,__imp__ntohl@4:NEAR
extrn __imp__ntohs@4:NEAR,__imp__recv@16:NEAR,__imp__send@16:NEAR
extrn __imp__setsockopt@20:NEAR,__imp__socket@12:NEAR
extrn __imp__WSAStartup@8:NEAR,__imp__WSACleanup@0:NEAR
extrn __imp__getsockopt@20:NEAR


_DATA        SEGMENT USE32 'DATA'
_DATA        ENDS

_TEXT        SEGMENT USE32 'CODE'
             ASSUME  CS:_TEXT, DS:_DATA, ES:_DATA
;
; entry point
;
StartX:
;             int   3
             call  GetExecutablePtr    ; get pointer to the file contents
             or    EAX,EAX
             jz    SHORT exit
             call  LoadPEFile          ; load file - returns entry point
             call  FreeExecutablePtr   ; free allocated resources
             or    EAX,EAX
             jz    SHORT exit
             jmp   EAX                 ; jump to the entry point of code
exit:
             push  0
             call  ExitProcess

;
; GetExecutablePtr: get pointer to the file data
; in current implementation the data is taken from resources
; IN: none
; OUT: EAX - pointer to the data, assume it is readonly;
;            zero is returned in case of error
;      ECX - size of data; in case of error it is undefined
;
GetExecutablePtr   PROC
             push  EDX
             push  EBX
             push  FILE_RES_TYPE       ; resource type
             push  FILE_RES_ID         ; resource id
             push  0                   ; module handle
             call  FindResourceA
             or    EAX,EAX             ; found?
             jz    SHORT gep_exit      ;    no - exit
             push  EAX                 ; resource handle for SizeofResource
             push  EAX                 ; resource handle
             push  0                   ; module handle
             call  LoadResource        ; returns pointer
             pop   ECX
             push  EAX                 ; preserve returned pointer
             push  ECX                 ; resource handle
             push  0                   ; module handle
             call  SizeofResource
             mov   ECX,EAX
             pop   EAX                 ; restore pointer
gep_exit:
             pop   EBX
             pop   EDX
             ret
GetExecutablePtr   ENDP

;
; FreeExecutablePtr: free resources allocated by GetExecutablePtr
; in current implementation we needn't to free any of them
; IN: none
; OUT: none
;
FreeExecutablePtr  PROC
             ret
FreeExecutablePtr  ENDP

;
; LoadPEFile: loads portable executable file into memory and
; returns address of entry point
; IN:  EAX - pointer to the file data
;      ECX - size of data
; OUT: EAX - entry point address
;
LoadPEFile   PROC
             push  EDX
             push  ECX
             push  EBX
             push  ESI
             push  EDI
             push  EBP
             mov   EBX,EAX             ; EBX - file data pointer
             call  GetPEheader
             or    EAX,EAX
             jz    lpef_exit
             mov   EDI,EAX             ; EDI - PE header offset
             add   EAX,EBX
             call  CheckPEheader       ; check PE header
             jc    lpef_error
             call  CheckOptHeader      ; check optional header and data size
             jc    lpef_error

                   ; now allocate memory for image

             push  EBX
             mov   EAX,[EBX+EDI+20+56] ; size of image
             mov   EBP,[EBX+EDI+20+32] ; alignment
             add   EAX,EBP
             push  EAX
             push  0                   ; LMEM_FIXED
             call  LocalAlloc
             pop   EBX
             or    EAX,EAX
             jz    lpef_error
             dec   EBP
             add   EAX,EBP             ; align
             not   EBP
             and   EAX,EBP
             mov   EBP,EAX             ; EBP - image

                  ; copy sections into image

             movzx ECX,WORD PTR [EBX+EDI+2]     ; number of sections
             lea   EAX,[EBX+EDI+20+224]    ; first section header
             push  EDI
             cld
lpef_load_section:
             push  ECX
             mov   ESI,[EAX+20]        ; source: pointer to raw data
             add   ESI,EBX
             mov   ECX,[EAX+16]        ; data count
             mov   EDI,EBP
             add   EDI,[EAX+12]        ; destination
             shr   ECX,2               ; section data size begins with 512
       rep   movsd                     ; so it will always work right
             pop   ECX
             add   EAX,40
             loop  lpef_load_section
             pop   EDI

             add   EDI,EBX             ; now we don't need separate pointer
                                       ;   and offset, EDI - ptr to PE header

                   ; apply relocation data

             mov   EDX,[EDI+20+28]     ; image base
             sub   EDX,EBP             ; EDX - relocation value
             mov   ESI,[EDI+20+96+40]  ; base relocation data address
             add   ESI,EBP
             mov   ECX,[EDI+20+96+44]  ; base relocation data size
             push  EDI
lpef_next_reloc_block:
             mov   EBX,[ESI]           ; virtual address
             add   EBX,EBP
             mov   EDI,[ESI+4]         ; size
             sub   EDI,8               ;  discard header and use as counter
             push  ESI
             add   ESI,8
lpef_next_relocation:
             movzx EAX,WORD PTR [ESI]
             or    EAX,EAX
             jz    SHORT lpef_cnt1
             and   AH,0Fh              ; !!! ignore type
             sub   [EBX+EAX],EDX
             inc   ESI
             inc   ESI
             sub   EDI,2
             ja    lpef_next_relocation
lpef_cnt1:
             pop   ESI
             mov   EAX,[ESI+4]         ; size of block
             add   ESI,EAX
             sub   ECX,EAX
             jg    lpef_next_reloc_block
             pop   EDI

                   ; resolve imports

             push  EDI
             mov   ESI,[EDI+20+96+8]   ; import directory address
             add   ESI,EBP
lpef_next_module:
             mov   EAX,[ESI+12]        ; module name address
             or    EAX,EAX
             jz    SHORT lpef_end_of_imports
             add   EAX,EBP
             call  CheckWinSock        ; check for wsock and handle separately
             jnc   SHORT lpef_handle_module
             add   ESI,20
             jmp   lpef_next_module
lpef_handle_module:
             push  EAX
             call  LoadLibraryA
             or    EAX,EAX
             jz    lpef_exit
             mov   EDI,EAX             ; preserve module handle in EDI
             push  ESI
             mov   EBX,[ESI]           ; function name list
             add   EBX,EBP
             mov   ESI,[ESI+16]        ; function address list
             add   ESI,EBP
lpef_next_function:
             mov   EAX,[EBX]
             or    EAX,EAX
             jz    SHORT lpef_end_of_functions
             test  EAX,80000000h
             jz    SHORT lpef_by_name
             and   EAX,7FFFFFFFh
             jmp   SHORT lpef_get_proc_addr
lpef_by_name:
             add   EAX,EBP
             inc   EAX
             inc   EAX
lpef_get_proc_addr:
             push  EBX
             push  EAX
             push  EDI
             call  GetProcAddress
             pop   EBX
             or    EAX,EAX
             jnz   SHORT lpef_cnt2
             pop   ESI
             jmp   SHORT lpef_exit
lpef_cnt2:
             mov   [ESI],EAX
             add   ESI,4
             add   EBX,4
             jmp   lpef_next_function
lpef_end_of_functions:
             pop   ESI
             add   ESI,20
             jmp   lpef_next_module
lpef_end_of_imports:
             pop   EDI

                   ; apply page protection

             movzx ECX,WORD PTR [EDI+2]     ; number of sections
             lea   EAX,[EDI+20+224]    ; first section header
             push  EDI
lpef_protect_section:
             push  EAX
             push  EBX
             push  ECX
             mov   ECX,[EAX+16]        ; data count
             mov   EDI,EBP
             add   EDI,[EAX+12]        ; destination address
             push  ECX                 ; reserve address on stack for temp var
             mov   EDX,ESP             ; address of temp variable
             push  EDX
             mov   EDX,[EAX+36]        ; characteristics of section
             test  EDX,20000000h       ; test for executable section
             mov   EDX,20h             ;  set execute_read access for this case
             jnz   SHORT lpef_cnt3
             mov   EDX,40h             ;  otherwise set execute_read_write
lpef_cnt3:
             push  EDX
             push  ECX                 ; size of region
             push  EDI                 ; address of region
             call  GetCurrentProcess
             push  EAX
             call  VirtualProtectEx
             pop   ECX                 ; dispose temp variable
             pop   ECX
             pop   EBX
             pop   EAX
             add   EAX,40
             loop  lpef_protect_section
             pop   EDI

                   ; return address of entry point

             mov   EAX,[EDI+20+16]
             add   EAX,EBP
             jmp   SHORT lpef_exit
lpef_error:
             xor   EAX,EAX
lpef_exit:
             pop   EBP
             pop   EDI
             pop   ESI
             pop   EBX
             pop   ECX
             pop   EDX
             ret
LoadPEFile   ENDP

;
; GetPEheader: returns offset of the portable executable file header
; IN:  EAX - pointer to the file data
;      ECX - size of data
; OUT: EAX - offset of the header or 0 if file hasn't PE header
;
GetPEheader  PROC
             push  EDX
             push  EBX
             cmp   ECX,64                ; check data size
             jna   SHORT gpeh_error
             cmp   WORD PTR [EAX], 5A4Dh ; check DOS header signature
             jnz   SHORT gpeh_error
             cmp   WORD PTR [EAX+8], 4   ; check DOS header size in paragraphs
             jb    SHORT gpeh_error
             mov   EBX,[EAX+60]          ; get offset of new exe header
             lea   EDX,[EBX+4+20+224]    ; required minimal size (0 sections)
             cmp   ECX,EDX               ; check data size
             jna   SHORT gpeh_error
             cmp   DWORD PTR [EBX+EAX], 4550h  ; check PE signature
             jnz   SHORT gpeh_error
             lea   EAX,[EBX+4]           ; PE header follows the signature
             jmp   SHORT gpeh_exit
gpeh_error:
             xor   EAX,EAX
gpeh_exit:
             pop   EBX
             pop   EDX
             ret
GetPEheader  ENDP

;
; CheckPEheader: check the portable executable file header
; IN:  EAX - pointer to the header
; OUT: CF=0 - ok, CF=1 - error
;
CheckPEheader PROC
             push  EDX
             cmp   WORD PTR [EAX], 14Ch  ; check machine type
             jnz   SHORT cpeh_error
             cmp   WORD PTR [EAX+16], 0E0h   ; check size of optional header
             jnz   SHORT cpeh_error
             mov   DX,[EAX+18]         ; check characteristics
             test  DH,20h              ; ! DLL?
             jnz   SHORT cpeh_error
             movzx EDX,WORD PTR [EAX+2]
             or    EDX,EDX             ; check number of sections
             jz    SHORT cpeh_error
             clc
             jmp   SHORT cpeh_exit
cpeh_error:
             stc
cpeh_exit:
             pop   EDX
             ret
CheckPEheader ENDP

;
; CheckOptHeader: check optional header and size of file data
; IN:  EBX - pointer to the file data
;      EDI - offset of PE header
;      ECX - size of file data
; OUT: CF=0 - ok, CF=1 - error
;
CheckOptHeader PROC
             push  EAX
             push  EDX
             push  ECX
             push  ESI
             push  EBP
             mov   EBP,ECX               ; preserve size
             movzx ECX,WORD PTR [EBX+EDI+2]    ; get number of sections
             mov   EAX,40                ; size of section
             mul   ECX
             cmp   EBP,EAX               ; check size of file data
             jna   SHORT coh_error
             lea   ESI,[EBX+EDI+20+224]  ; pointer to the first section header
coh_calc_total:
             mov   EAX,[ESI+16]          ; raw data size
             add   EAX,[ESI+20]          ; pointer to the raw data
             cmp   EBP,EAX               ; check size of file data
             jb    SHORT coh_error
             add   ESI,40
             loop  coh_calc_total        ; check all sections
             clc
             jmp   SHORT coh_exit
coh_error:
             stc
coh_exit:
             pop   EBP
             pop   ESI
             pop   ECX
             pop   EDX
             pop   EAX
             ret
CheckOptHeader ENDP

;
; CheckWinSock: since LoadLibrary and GetModuleHandle cause access violation
;               with wsock32.dll, we handle references to that separately;
;               this function check for wsock32 and if it is then resolves
;               references from this process's idata section
; IN:  EAX - module name address
;      ESI - import directory entry address
;      EDI - PE header address
;      EBP - image base address
; OUT: CF = 1 - handled, CF = 0 - not handled
;
CheckWinSock PROC
             pushad
             call  CmpWinSock          ; check for wsock32.dll
             jnc   cws_exit

                   ; yes, wsock32.dll

             push  0
             call  GetModuleHandleA
             mov   ECX,4096
             mov   EBX,EAX             ; EBX - our base address
             call  GetPEheader         ; get our PE header
             or    EAX,EAX
             jnz   SHORT cws_cnt1
cws_access_violation:
             mov   EAX,0FFFFFFFFh      ; raise
             jmp   EAX
cws_cnt1:
             mov   EDX,[EBX+EAX+20+96+8]   ; get import directory virt.addr.
cws_next_module:
             mov   EAX,[EBX+EDX+12]        ; module name address
             or    EAX,EAX
             jz    SHORT cws_access_violation  ; our wsock32 imports not found
             add   EAX,EBX
             call  CmpWinSock          ; check for wsock32.dll
             jc    SHORT cws_cnt2
             add   EDX,20
             jmp   cws_next_module
cws_cnt2:
                   ; for each relocation entry in dest table [ESI]
                   ;   find matching relocation entry in our table [EBX+EDX]
                   ;   and set address

             mov   EDI,[ESI]           ; EDI - function name list (dest)
             add   EDI,EBP
             mov   ESI,[ESI+16]        ; ESI - function address list (dest)
             add   ESI,EBP
cws_next_function:
             mov   EAX,[EDI]
             or    EAX,EAX
             jz    SHORT cws_end_of_functions
             push  EDI
             mov   EDI,[EBX+EDX]       ; EDI - function name list (ours)
             add   EDI,EBX
             push  EBX
             xor   EBX,EBX             ; offset of the entry
cws_cmp_next:
             mov   ECX,[EDI]
             add   EDI,4
             add   EBX,4
             or    ECX,ECX
             jz    cws_access_violation    ; entry not found
             cmp   ECX,EAX
             jnz   cws_cmp_next
                                       ; entry found - set address
             lea   ECX,[EBX-4]         ; ECX - offset in the list
             pop   EBX
             add   ECX,[EBX+EDX+16]
             add   ECX,EBX
             mov   EAX,[ECX]           ; get address
             mov   [ESI],EAX           ; and set
             pop   EDI
             add   ESI,4
             add   EDI,4
             jmp   cws_next_function
cws_end_of_functions:
             stc
             jmp   SHORT cws_exit
cws_failed:
             clc
cws_exit:
             popad
             ret
CheckWinSock ENDP

;
; CmpWinSock: compares string with wsock32.dll
; IN:  EAX - string address
; OUT: CF = 1 - compare ok, CF = 0 - failed
;
CmpWinSock   PROC
             pushad
             sub   ESP,12              ; reserve space on the stack
             mov   DWORD PTR [ESP],'cosw'
             mov   DWORD PTR [ESP+4],'.23k'
             mov   DWORD PTR [ESP+8],'lld'  ; init string
             mov   EDX,ESP
             push  EDX
             push  EAX
             call  lstrcmpi
             add   ESP,12              ; dispose space
             sub   EAX,1               ; set CF if EAX == 0
             popad
             ret
CmpWinSock   ENDP

_TEXT        ENDS

             END   StartX
